#version 330
#extension GL_EXT_gpu_shader4 : enable
// Bubble fadesMod01.fsh  by   farious

//https://www.shadertoy.com/view/3tfGD7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265359

mat2 rot(float a) { return mat2(cos(a), -sin(a), sin(a), cos(a)); }

float circle(vec2 uv) {
    return sqrt(dot(uv, uv));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	// ** UV
    vec2 uv = ((gl_FragCoord.xy -.5*iResolution.xy)/iResolution.y); // Normalized pixel coordinates (from 0 to 1)
    uv = uv * rot(iTime*0.1); // Normalized rotating uv
    
    // Rotation matrix
    float n = 6.+abs(sin(iTime*0.1)*2.); // Grid size
    
    // Cell ID
    vec2 idv2 = (floor(uv*n) + vec2(n,0));;
    float id = idv2.x*n + idv2.y;
    
    // ** Grids
    vec2 guv = fract(uv*n) -.5; // Grid uv
    vec2 roguv = guv; roguv *= rot(iTime); // Rotating grid uv - around self origin

    // Circle uv
    float r1 = 0.45 * sin(dot(idv2, idv2) + iTime)*sin(id*0.5), r2 = 0.5;
    vec2 croguv = roguv * (1.-smoothstep(r1,r2, circle(roguv)));
    
    // Final color
    vec3 fc = dot(croguv,croguv)/0.25*vec3(1.);
    vec3 col = fc;

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}